/**
 *
 * \file        dm_dmnet_master.hpp
 *
 * \brief       header file for DM Net Master
 * 
 * \author      Pranav Bhargava
 *
 * \date        03/25/2009
 *
 */
#ifndef _DM_DMNET_MASTER_HPP_
#define _DM_DMNET_MASTER_HPP_

#include "dm_cresnet.h"
#include "dm_errors.h"
#include <string.h>
#include "dm_os.h"
#include "dm_uart_cresnet_master.h"
#include "dm_console.h"
//#include <ctype.h>
// #include "dm_cip.h"
#include "memorymanager.h"
#include <stdlib.h>
#include <stdio.h>

#include "dm_CresnetHardware.hpp"
#include "dm_OsEvent.hpp"
#include "CresnetStruct.h"
#include "HwInterf.h"
#include "uart.h"
#include "dm_NetMapper.hpp"
#include "DmEncapChecksumHelper.h"

#define TOTAL_NUMBER_OF_DM_MASTERS 	1
#define MASTER_POLL_TIME 			40 //time in msec between start of polls
#define POLL_AGAIN_IMMEDIATE 		0xff
#define MASTER_RX_ENCAP_OFFSET 		3
#define DM_WAIT_FOR_RESPONSE_MS 	50 // for DmPoll()
#define DM_WAIT_FOR_SYNC_END_MS 	5 // for SendSync()
#define MISSING_DEVICE_POLLS 		2  // missed polls before declaring device OFFLINE

#define DM_MASTER_NET_MODE_HISTORY_SIZE      25

// cresnet host events
#define DMH_EVENT_NONE  				0
#define DM_EVENT_READY					0x00000001 // sends when event is initialized
#define DMH_EVENT_SYNC_DONE				0x00000002          // e.g. sync is sent out
#define DMH_EVENT_NO_RESPONSE			0x00000004
#define DMH_EVENT_EMPTY_TOKEN			0x00000008
#define DMH_EVENT_DATA_RECEIVED			0x00000010
#define DMH_EVENT_DATA_TIMEOUT			0x00000020 // timeout in the middle of the packet
#define DMH_EVENT_DATA_ERROR			0x00000040
#define DMH_EVENT_FATAL_ERROR_TIMER		0x00000080
#define DMH_EVENT_FATAL_ERROR_UART		0x00000100
#define DMS_EVENT_POLL_START_SEND		0x00000200 // can do host poll
#define DMS_EVENT_POLL_START_RECEIVED 	0x00000400 // other task sends confirmation
#define DMS_EVENT_POLL_STOP_SEND		0x00000800 // cannot do host poll
#define DMS_EVENT_POLL_STOP_RECEIVED	0x00001000 // other task sends confirmation
#define DMH_EVENT_INALID				0x00002000


#define ALL_DM_EVENT_MASK ( \
					DM_EVENT_READY | \
					DMH_EVENT_SYNC_DONE | \
					DMH_EVENT_SYNC_DONE | \
					DMH_EVENT_NO_RESPONSE	| \
					DMH_EVENT_EMPTY_TOKEN   | \
					DMH_EVENT_DATA_RECEIVED | \
					DMH_EVENT_DATA_TIMEOUT  | \
					DMH_EVENT_DATA_ERROR    | \
					DMH_EVENT_FATAL_ERROR_TIMER  | \
					DMH_EVENT_FATAL_ERROR_UART   | \
					DMS_EVENT_POLL_START_SEND    | \
					DMS_EVENT_POLL_START_RECEIVED	| \
					DMS_EVENT_POLL_STOP_SEND     | \
					DMS_EVENT_POLL_STOP_RECEIVED | \
					DMH_EVENT_INALID)
#pragma pack()

class CDMCresnetUartHost;
#if defined (DM6X4_BUILD) || defined (MPS_DM_BUILD)
// On the 6x4 this is driven off the shared FPGA interrupt so it is not a LISR per se...
class CDMCresnetHostPortLISR
{
    public:

        CDMCresnetUartHost* m_pOwner;
        CDMCresnetHostPortLISR(CDMCresnetUartHost *Creator, int Vector );
        void        EntryRoutine();     // Actual ISR.

};
#else
class CDMCresnetHostPortLISR : public LowLevelInterrupt
{
    public:

        CDMCresnetUartHost* m_pOwner;
        CDMCresnetHostPortLISR(CDMCresnetUartHost *Creator, int Vector );
        virtual void        Entry();     // Actual ISR.

};
#endif

class CDMCresnetHostTimerLISR : public LowLevelInterrupt
{
    private:
        CDMCresnetUartHost * m_pOwner;

    public:
        CDMCresnetHostTimerLISR(CDMCresnetUartHost *Creator, int Vector );
        void        Entry();   // Actual ISR.
};

// Declare HISR class for Console Rx
class CDMCresnetHostRxHISR: public HighLevelInterrupt
{
    private:
        CDMCresnetUartHost * m_pOwner;

    public:
        CDMCresnetHostRxHISR(CDMCresnetUartHost * Creator);
        void  Entry();   // Actual high level ISR.
};

// Declare HISR class for Console Rx
class CDMCresnetHostTimerHISR: public HighLevelInterrupt
{
    private:
        CDMCresnetUartHost * m_pOwner;

    public:
        CDMCresnetHostTimerHISR(CDMCresnetUartHost * Creator);

      
        void  Entry();   // Actual high level ISR.
};

class CDMCresnetHostTask: public Task
{
	// Actual task object entry point.

	
	CDMCresnetUartHost * m_pOwner;
	protected:
		CDMCresnetHostTask(CDMCresnetUartHost *);
		virtual VOID Entry();
};


class CDMCresnetUartHost: public CGeneralUartPort
{
	private:
		UINT8 m_bStreamId;

	public:
		int     m_iLeg ;
        UINT8 extra[OS_TASK_EXTRA_BYTES];   // not sure what for

		CDMCresnetHostPortLISR      * m_pLISR;
        CDMCresnetHostTimerLISR     * m_pTimerLISR;
        CDMCresnetHostTimerHISR     * m_pTimerHISR;
        CDMCresnetHostRxHISR        * m_pRxHISR;
		CColdfire_BaseTimer       	* m_pTimer;
		CDMCresnetHostTask			*m_pDMHostTask;

        static UINT8     m_iTotalDmHosts;
        UINT8     m_iPollState ;
        UINT8     m_TaskStarted;
        UINT8     m_PendingStopPoll;
   
        CREST_ALL_PACKETS   m_pTxPacket ; // packet to be sent is stored here
        CREST_ALL_PACKETS   *m_pTxQueue;  // Output packet queue;  only used in reverse control flow.
                                          // set by join state only (no lock needed)
        CREST_ALL_PACKETS   m_pPacket ; // received packet is stored here

        void SetNetMode( DM_CRESNET_HOST_STATE_ENUM iNetMode );
        DM_CRESNET_HOST_STATE_ENUM m_iNetModeHistory[DM_MASTER_NET_MODE_HISTORY_SIZE];

        DM_CRESNET_HOST_STATE_ENUM volatile m_iNetMode ;   // what it's doing now: sending token, wait on rcv, rcv, etc...
        int m_iRxCount ;    // -1: wait for length,valid only if m_iNetMode == DM_MASTER_STATE_WAIT_FOR_RESPONSE or STATE_RECIEVING
        int m_iRxExpected ; // -1: wait for length,valid only if m_iNetMode == DM_MASTER_STATE_WAIT_FOR_RESPONSE or STATE_RECIEVING
        UINT16 m_iTxCount ;
        UINT16 m_iTxCurrent ;
        int m_iResponded ; // 0 - no response, 1 - responded, set to 0 before every token
        UINT8 no_response_cnt;
        UINT8 report_Data_cnt;    // packet should be send to slave side
        BOOL m_bOnline;    // this corresponds to a single slave DmNet device
		UINT8 m_iCurrent;  // which slave ID is polled
		UINT8 m_iDmNet;	  // which DmNET leg

        EventGroup     *m_pEventGroup;      // ISR events
        CDMNetMapper	*m_pDMNetMapper;
		CMutex                 * m_pCresnetSemaphore ;
        BOOL m_bEnabled;

        CDMCresnetUartHost(UINT8 UartSelect,UINT8 outputCardCresnetId, DmEncapChecksumHelper* pHelper = 0);
		~CDMCresnetUartHost() ;        // empty for now

        void SetDefaults(pUART_PARAM param);
        void ResetState(void) ; // clear all the variables before polling

        INT8 ObtainCrestSema(UINT32 wait ) ;
        INT8 ReleaseCrestSema(void)  ;

        INT8 PollDevice(void) ;
        INT8 SendPacket(CREST_ALL_PACKETS *packet) ;        // send packet, wait until poll resumes
        INT8 SendToken(UINT8 cnetId) ;        // send token and wait for response
        INT8 SendSync(void);
        void StopPolling(void)  ;
        void StartPolling(void) ;

		void GrabBus();
		void DropBus();
					  

        void DmHostTask(void) ; // process received packet

        void DmHostTimerISR(void);
        void DmHostUartISR(void);
        UINT32 MasterMidpointRxIsr(void);
        INT8 DmProccessPacketRx(void);
        void DmProccessPacketTx(UINT8 Command);
        void DmSetOnLineStatus(UINT8);
        bool HostEnqueueOutgoingPacket(CREST_ALL_PACKETS *pPacket, UINT16 lLength);
        bool OutputQueueAvailable(void);
        bool IsDeviceConnected(void);
        CREST_ALL_PACKETS *DmHostGetNextPacket(void) ; // returns pointer if packet set
        void DmHostReleaseNextPacket(void) ; // returns pointer if packet set

        DmEncapChecksumHelper* m_pEncapChecksumHelper;
#if defined (DM6X4_BUILD) || defined (MPS_DM_BUILD)
         void Reconfigure(BOOL bEnable);
#endif
};

#ifdef __cplusplus
extern "C" {
#endif

INT32 ReportDMnetCmd(UINT32,char*);
#ifdef __cplusplus
}
#endif

//INT8 GetNumberOfDmHosts(void);

//void print_ah_debug(char *str, UINT16 len) ;
#define  print_packet(x,s) DmConsoleHexDumpPacket((UINT8 *)(x),((UINT16)((x)[1])+2),s,0)


// global class pointers cresnet master classes
#ifndef _CRESNET_HOST_CPP_

extern CDMCresnetUartHost *g_pDmMaster[];

#endif

#endif // _DM_DMNET_MASTER_H_

